public class AVL extends Arbol{
	
	public AVL(){
		super();
	}
	
	void insertar(double x){
		if(raiz==null){
			raiz=new Nodo(x);
			return;
		}
		Nodo aux=raiz;
		while(true){ 
			if(aux.info==x){
				aux.rep++;
				return;}
			if(aux.info<x){
				if(aux.der==null){
					aux.der=new Nodo(x);
					aux.der.padre=aux;
					balancear(aux);
					return;
				}else{
					aux=aux.der;
				}
			}else{
				if(aux.izq==null){
					aux.izq=new Nodo(x);
					aux.izq.padre=aux;
					balancear(aux);
					return;
				}else{
					aux=aux.izq;
				}
			}
		}
	}
	
	boolean buscar(double x){
		Nodo aux=raiz;
		while(true){
			if(aux==null){
				return false;
			}else if(aux.info==x){
				return true;
			}else if(aux.info>x){
				aux=aux.izq;
			}else{
				aux=aux.der;
			}
		}
	}
	
	void balancear(Nodo n){
		Nodo aux=n;
		while(true){
			if(aux==null){return;}
			if(Math.abs(altura(aux.der)-altura(aux.izq))>1){
				Nodo p=aux.padre;
				double d=aux.info;
				if(altura(aux.der)>altura(aux.izq)){
					rotDer(aux);
				}else{
					rotIzq(aux);
				}
				p=(p==null)?raiz:(p.info<d)?p.der:p.izq;
				p.izq.alt=1+Math.max(altura(p.izq.der),altura(p.izq.izq));
				p.der.alt=1+Math.max(altura(p.der.der),altura(p.der.izq));
				p.alt=1+Math.max(altura(p.der),altura(p.izq));
				return;
			}else{
				aux.alt=1+Math.max(altura(aux.der),altura(aux.izq));
				aux=aux.padre;
			}
		}
	}
	
	void rotIzq(Nodo n){
		Nodo aux=n.izq;
		if(altura(aux.izq)>altura(aux.der)){
			if(n.padre==null){
				raiz=aux;
			}else{
				if(n.padre.info<aux.info){
					n.padre.der=aux;
				}else{
					n.padre.izq=aux;
				}
			}
			aux.padre=n.padre;
			n.izq=aux.der;
			if(n.izq!=null){
				n.izq.padre=n;
			}
			aux.der=n;
			n.padre=aux;
		}else{
			if(n.padre==null){
				raiz=aux.der;
			}else{
				if(n.padre.info<aux.info){
					n.padre.der=aux.der;
				}else{
					n.padre.izq=aux.der;
				}
			}
			aux.der.padre=n.padre;
			n.izq=aux.der.der;
			if(n.izq!=null){
				n.izq.padre=n;
			}
			aux.der.der=n;
			n.padre=aux.der;
			aux.der=aux.der.izq;
			if(aux.der!=null){
				aux.der.padre=aux;
			}
			aux.padre=n.padre;
			aux.padre.izq=aux;
		}
	}
	
	void rotDer(Nodo n){
		Nodo aux=n.der;
		if(altura(aux.der)>altura(aux.izq)){
			if(n.padre==null){
				raiz=aux;
			}else{
				if(n.padre.info<aux.info){
					n.padre.der=aux;
				}else{
					n.padre.izq=aux;
				}
			}
			aux.padre=n.padre;
			n.der=aux.izq;
			if(n.der!=null){
				n.der.padre=n;
			}
			aux.izq=n;
			n.padre=aux;
		}else{
			if(n.padre==null){
				raiz=aux.izq;
			}else{
				if(n.padre.info<aux.info){
					n.padre.der=aux.izq;
				}else{
					n.padre.izq=aux.izq;
				}
			}
			aux.izq.padre=n.padre;
			n.der=aux.izq.izq;
			if(n.der!=null){
				n.der.padre=n;
			}
			aux.izq.izq=n;
			n.padre=aux.izq;
			aux.izq=aux.izq.der;
			if(aux.izq!=null){
				aux.izq.padre=aux;
			}
			aux.padre=n.padre;
			aux.padre.der=aux;
		}
	}
	
	int altura(Nodo n){
		return((n==null)?-1:n.alt);
	}
	
	void print(){
		print(raiz);
	}
	
	void print(Nodo n){
		if(n==null){
			return;
		}
		print(n.izq);
		System.out.println(n.info+" multiplicidad="+n.rep);
		print(n.der);
	}
}
